﻿Imports System.IO

Public Class ScopeForm

    Private number As Integer

    Public Sub New(ByVal fields As String(), ByVal settings As ScopeSettings)

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.

        DataFields = fields

        Me.Text &= " " & settings.Number
        Me.Left = settings.Left
        Me.Top = settings.Top

        number = settings.Number
        ListBoxSignal1.SelectedIndex = settings.Signal1Index    ' First entry
        ListBoxSignal2.SelectedIndex = settings.Signal2Index    ' Nothing by default
        TextBoxSignalMax.Text = settings.Max
        TextBoxSignalMin.Text = settings.Min
        CheckBoxSignalAuto.Checked = settings.Auto
    End Sub

    Public ReadOnly Property GetSettings() As ScopeSettings
        Get
            Dim mySettings As New ScopeSettings
            mySettings.Number = number
            mySettings.Top = Me.Top
            mySettings.Left = Me.Left
            mySettings.Signal1Index = ListBoxSignal1.SelectedIndex
            mySettings.Signal2Index = ListBoxSignal2.SelectedIndex
            mySettings.Min = TextBoxSignalMin.Text
            mySettings.Max = TextBoxSignalMax.Text
            mySettings.Auto = CheckBoxSignalAuto.Checked
            Return mySettings
        End Get
    End Property

    Public Property DataFields() As String()
        Get
            Return datafieldsValue
        End Get
        Set(ByVal value As String())
            datafieldsValue = value
            ListBoxSignal1.Items.Clear()
            ListBoxSignal1.Items.AddRange(value)
            ListBoxSignal2.Items.Clear()
            ListBoxSignal2.Items.AddRange(value)
            ListBoxSignal2.Items.Insert(0, "No signal")
        End Set
    End Property
    Private datafieldsValue As String()

    Private Sub CheckBoxSignalAuto_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles CheckBoxSignalAuto.CheckedChanged
        ScrollControl1.Auto = CheckBoxSignalAuto.Checked
        TextBoxSignalMax.Enabled = Not CheckBoxSignalAuto.Checked
        TextBoxSignalMin.Enabled = Not CheckBoxSignalAuto.Checked
    End Sub

    Private Sub TextBoxSignalMax_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TextBoxSignalMax.TextChanged
        If Not ScrollControl1.Auto And IsNumeric(TextBoxSignalMax.Text) Then
            ScrollControl1.Max = TextBoxSignalMax.Text
        End If
    End Sub

    Private Sub TextBoxSignalMin_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TextBoxSignalMin.TextChanged
        If Not ScrollControl1.Auto And IsNumeric(TextBoxSignalMin.Text) Then
            ScrollControl1.Min = TextBoxSignalMin.Text
        End If
    End Sub

    Private Sub ScrollControl_MaxMinAutoChanged() Handles ScrollControl1.MaxMinAutoChanged
        TextBoxSignalMax.Text = ScrollControl1.Max
        TextBoxSignalMin.Text = ScrollControl1.Min
    End Sub

    Private Sub ListBoxSignal2_SelectedValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListBoxSignal2.SelectedValueChanged, ListBoxSignal1.SelectedValueChanged
        If CheckBoxSignalAuto.Checked Then
            ScrollControl1.Auto = False ' Reset autoscaling
            ScrollControl1.Auto = True
        End If

        If ListBoxSignal2.SelectedItem = "No signal" Then
            ScrollControl1.Value2Enabled = False
        Else
            ScrollControl1.Value2Enabled = True
        End If
    End Sub
End Class